<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use DB;
class CheckDatabaseConnection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {   
        try {
          
            DB::connection()->getPdo();

            if(DB::connection()->getDatabaseName()){
                return $next($request);
            }else{
                $errorMessage = "La Base de Donnée ".DB::connection()->getDatabaseName()." n'a pas été trouvée. Veuillez verifier les configurations.";
                //return view('', compact('errorMessage'));
                return response()->view('errors.401', ['data' => $errorMessage]);
            }
        } catch (\Exception $e) {
             $errorMessage = "La connection au serveur de la base de donnée n'a pas été etablie.  Veuillez verifier si le serveur de la base de donnée est allumé.";
             return response()->view('errors.401', ['data' => $errorMessage]);
        }
        
    }
}
