@extends('layout.base', ['title' => 'Assurance - Immobilier'])

@section('content')
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
      </div><!-- /.container-fluid -->
    </section><hr />
 <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <h3 class="card-title">Liste des Immobiliers</h3>
                <div class="row">
                  <div class="col-md-9"></div>
                 @can('immobilier-create')
                    <!--div class="col-md-3" onclick="showform()"><a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                            <i class="ti-plus"></i> Ajouter immobilier.
                                    </a></div-->
                  @endcan
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-striped">
                  <thead>
                  <tr>
                                            <th>Nom</th>
                                            <th>Date acquis</th>
                                            <th>Moyen acquis</th>
                                            <th>Mise en service</th>
                                            <th>Montant</th>
                                            <th>Durée (ans)</th>
                                            <th>Taux (%)</th>
                                            <th>Methode Appliquée</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    
                                     @foreach ($Biens as $Bien)
                                        

                                         <tr class="odd gradeX">
                                            <td>{{ $Bien->Nom }}</td>
                                            <td>{{ $Bien->Date_acquis }}</td>
                                            <td>{{ $Bien->Moyen_acquis }}</td>
                                            <td>{{ $Bien->Mis_service }}</td>
                                            <td>{{ $Bien->Montant }}</td>
                                            <td>{{ $Bien->Duree }}</td>
                                            <td>{{ $Bien->Taux }}</td>
                                            <td>{{ $Bien->Methode }}</td>
                                            <td>
                                              @can('immobilier-edit')
                                              <button data-toggle="modal" data-target="#modal-default"  value="{{$Bien}}" style="border: none; cursor: pointer;">
                                                 <i class="fa fa-edit"></i>
                                              </button>
                                             @endcan 
                      
                                             <!--a href="{{ route('Bien.show', $Bien) }}">
                                               <i class="fas fa-eye"></i>
                                             </a--> 
                                             @can('plan-ammortissement')
                                             <button style="border: none;cursor: pointer;" target="PromoteFirefoxWindowName" onclick="openFFPromotionPopupForDepreciationPlan(this); return false;" value="{{$Bien->id}}"><i class="fa fa-eye"></i></button>
                                             @endcan
                                             </td>
                                    </tr> 
                                    @endforeach   
                                      
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
        </section>
      </div>
             <!-- /. PAGE INNER  -->






                                   <!-- Modal Add Category -->
                <div class="modal fade none-border" id="add-new-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Nouvel Immobilier</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>

                        <form method="POST" action="{{route('Bien.store')}}">
                            <div class="modal-body">
                                    {{ csrf_field() }}
                                    <div class="row">
                                      <div class="col-md-12">
                                        <label>Type d'immobilier*</label>
                                        <select class="form-control select2" name="Type">
                                           @foreach($Depreciationtype as $Depreciation)
                                              <option value="{{$Depreciation->id}}">{{$Depreciation->Type}}</option>
                                           @endforeach
                                        </select>
                                        {!! $errors->first('Type', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                       <label>Nom *</label>
                                         <input type="text" class="form-control" name="Nom" />
                                        {!! $errors->first('Nom', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                        <label>Date Acquisition *</label>
                                         <input type="date" class="form-control" name="Dateacquis" />
                                         {!! $errors->first('Dateacquis', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                        <label>Moyen Acquisition *</label>
                                        <select class="form-control select2" name="Moyen">
                                           <option value="Achat">Achat</option>
                                           <option value="Don">Don</option>
                                           <option value="Leg">Don</option>
                                        </select>
                                        {!! $errors->first('Moyen', '<span class="error">:message</span>') !!}
                                      </div>
                        
                                      <div class="col-md-12">
                                        <label>Date Production *</label>
                                         <input type="date" class="form-control" name="Misservice"/>
                                         {!! $errors->first('Misservice', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                        <label>Montant Acquisition *</label>
                                         <input type="number" class="form-control" name="Montant"/>
                                         {!! $errors->first('Montant', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                        <label>Provenance </label>
                                         <input type="text" class="form-control" name="Provenance"/>
                                         {!! $errors->first('Provenance', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-12">
                                        <label>Durée *</label>
                                         <input type="number" class="form-control" name="Duree" id="duree" oninput="getDuree(this)" />
                                         {!! $errors->first('Duree', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-6">
                                        <label>Taux *</label>
                                          <input type="number" class="form-control" name="Taux" readonly="readonly" id="Taux" />
                                           {!! $errors->first('Taux', '<span class="error">:message</span>') !!}
                                      </div>

                                      <div class="col-md-6">
                                        <label>Methode Amortissement *</label>
                                         <select class="form-control select2" name="Methode">
                                           <option value="Lineaire">Lineaire</option>
                                           <option value="Progressif">Progressif</option>
                                           <option value="Variable">Variable</option>
                                        </select>
                                         {!! $errors->first('Duree', '<span class="error">:message</span>') !!}
                                      </div>

                                  </div>
                                </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>














@endsection 

<script type="text/javascript">
   var WindowObjectReference = null; // variable globale
   function openFFPromotionPopupForDepreciationPlan(va) {
     var id = $(va).val();
     var url = "{{ route('Bien.show', ":id") }}";
     url = url.replace(':id', id);
  if (WindowObjectReference == null || WindowObjectReference.closed) {
    WindowObjectReference = window.open(url,"PromoteFirefoxWindowName", "toolbar=no,scrollbars=no,location=no,statusbar=no,width=940,height=500,resizable,scrollbars=yes,status=1,menubar=no");
  }
  else {
    WindowObjectReference.focus();
  };
}


function getDuree(va){
    var Duree= $(va).val();
    var Taux = 100/Duree;
    $('#Taux').val(Taux);
  }
</script>