@extends('layout.base')
@section('content')                         
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <h3 class="card-title">Comptes Tiers</h3>
                @can('compte_principal-create')
                <div class="row">
                  <div class="col-md-8"></div>
                  <div class="col-4">
                   <a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                        <i class="ti-plus"></i> Nouveau Compte
                    </a>
                  </div>
                </div>
                @endcan
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-striped">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Numero</th>
                      <th>Intitulé</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  @foreach($Tiers as $Compte)
                    <tr>
                      <td>{{$Compte->id}}</td>
                      <td>{{$Compte->NumeroCompte}}</td>
                      <td>{{$Compte->Intitule}}</td>
                    <td>
                      @can('compte_principal-edit')
                        <button data-toggle="modal" data-target="#add-older-event" value="{{$Compte->id}}" onclick="getCompteTiers(this)">
                        <i class="fas fa-edit"></i>
                        </button>
                      @endcan
                      @can('compte_principal-delete')
                        <form action="{{route('CompteGeneral.destroy', $Compte->id)}}" method='POST' style='display: inline-block;' onsubmit="return confirm('Etez-vous sur de cette Operation ?')">
                          {{csrf_field()}}
                          {{method_field('DELETE')}}
                          <button onclick="return confirm('Etez -vous sur de cette Operation ?')"><i class='fas fa-trash'></i>
                          </button>
                        </form>
                      @endcan
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</section></div>

                     <!-- Modal Add Category -->
                <div class="modal fade none-border" id="add-new-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Creer un Compte</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('Tiers.store')}}">
                            <div class="modal-body">
                            {{ csrf_field() }}
                            <div class="row">
                              <div class="col-md-6">
                                <label class="control-label">Numero compte *</label>
                                <input class="form-control form-white" placeholder="Numero compte" type="text" name="Numero" />
                                {!! $errors->first('Numero', '<span class="error">:message</span>') !!}
                              </div>
                              <div class="col-md-6">  
                                <label class="control-label">Intitulé *</label>
                                <input class="form-control form-white" placeholder="Intitulé" type="text" name="Intitule" />
                                {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}
                              </div>

                              <div class="col-md-6">  
                                <label class="control-label">Tiers *</label>
                                <select class="form-control select2" name="Tier_type">
                                  <option value="Client">Client</option>
                                  <option value="Fournisseur">Fournisseur</option>
                                  <option value="Salarié">Salarié</option>
                                  <option value="Actionnaire">Actionnaire</option>
                                </select>
                                {!! $errors->first('Tier_type', '<span class="error">:message</span>') !!}
                              </div>

                              <div class="col-md-6">  
                                <label class="control-label">Compte Géneral *</label>
                                <select class="form-control select2" name="Compte_id">
                                  @foreach($NatureComptes as $NatureCompte)
                                    <option value="{{$NatureCompte->id}}">{{$NatureCompte->NumeroCompte}} -- {{$NatureCompte->Intitule}}</option>
                                  @endforeach  
                                </select>
                                {!! $errors->first('Compte_id', '<span class="error">:message</span>') !!}
                              </div>
                            </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>

                <div class="modal fade none-border" id="add-older-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Modifier un Compte</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('UpdateCompteTiers')}}">
                            <div class="modal-body">
                            {{ csrf_field() }}
                                    {{ method_field('PUT') }}
                            <div class="row">
                              <input type="text" name="Identifiant" id="Identifiant" style="display: none;">
                              <div class="col-md-6">
                                <label class="control-label">Numero compte *</label>
                                <input class="form-control form-white" placeholder="Numero compte" type="text" name="Numero" id="Numero"/>
                                {!! $errors->first('Numero', '<span class="error">:message</span>') !!}
                              </div>
                              <div class="col-md-6">  
                                <label class="control-label">Intitulé *</label>
                                <input class="form-control form-white" placeholder="Intitulé" type="text" name="Intitule" id="Intitule" />
                                {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}
                              </div>

                              <div class="col-md-6" id="Tiers">  
                              </div>

                              <div class="col-md-6" id="Compte_gENER">  
                              </div>
                            </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
                <!-- END MODAL -->
                </div>



                <!-- ============================================================== -->
                <!-- End PAge Content -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- Right sidebar -->
                <!-- ============================================================== -->
                <!-- .right-sidebar -->
                <!-- ============================================================== -->
                <!-- End Right sidebar -->
                <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
@endsection

<script type="text/javascript">
  function getCompteTiers(va){
    var compte= $(va).val();
    $.get('{{route('getCompteTiersId')}}',
    {compte:compte},
    function(data){
      var donnee = data.split("#");
      $("#Identifiant").val(compte);
      $("#Numero").val(donnee[0]);
      $("#Intitule").val(donnee[1]);
      $("#Tiers").val(donnee[2]);
      $("#Compte_gENER").val(donnee[3]);
    });
  }
</script>                                  