@extends('layout.base')
@section('content')
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <div class="row">
                  <div class="col-md-8"></div>
                  <div class="col-4"><a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                  <i class="ti-plus"></i> Nouvelle Fourchette
                  </a></div>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">                                           
                <table class="table table-striped">
                  <thead>
                    <tr>
                      <th>Borne Inferieur</th>
                      <th>Borne Superieur</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                     @foreach($Fourchettes as $Fourchette)
                       <tr>
                          <td>{{$Fourchette->borne_inf}}</td>
                          <td>{{$Fourchette->borne_sup}}</td>

                          <td>
                          <button style="border: none;" data-toggle="modal" data-target="#add-older-event" value="{{$Fourchette->id}}" onclick="getFourchette(this)">
                          <i class="fas fa-edit"></i>

                          <form action="{{route('Fourchette.destroy', $Fourchette->id)}}" method='POST' style='display: inline-block;' onsubmit="return confirm('Etez-vous sur de cette Operation ?')">
                              {{csrf_field()}}
                              {{method_field('DELETE')}}
                              <button style="border: none;" onclick="return confirm('Etez -vous sur de cette Operation ?')"><i class='fas fa-trash'></i>
                              </button>
                          </form>
                        </td>
                       </tr>
                     @endforeach
                  </tbody>
                </table>
              </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
        </section>
      </div>

      <!-- Modal Add Category -->
      <div class="modal fade none-border" id="add-new-event">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title"><strong>Creer une nouvelle Fourchette</strong></h4>
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <form method="POST" action="{{ route('Fourchette.store')}}">
              <div class="modal-body">
                {{ csrf_field() }}
                <div class="row">
                  <div class="col-md-6">
                    <input type="text" name="nature" value="{{$id}}" style="display: none;">
                    <label class="control-label">Borne Inferieur *</label>
                      <input type="text" name="borne_inf" class="form-control">
                      {!! $errors->first('borne_inf', '<span class="error">:message</span>') !!}
                  </div>
                  <div class="col-md-6">
                    <label class="control-label">Borne Superieur *</label>
                     <input type="text" name="borne_sup" class="form-control">
                      {!! $errors->first('borne_sup', '<span class="error">:message</span>') !!} 
                  </div>
                </div>
              </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
                <!-- END MODAL -->


           <!-- Modal Add Category -->
      <div class="modal fade none-border" id="add-older-event">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title"><strong>Modifier une Fourchette</strong></h4>
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <form method="POST" action="{{ route('UpdateFourchette')}}">
              <div class="modal-body">
                {{ csrf_field() }}
                {{ method_field('PUT') }}
                <div class="row">
                  <div class="col-md-6">
                    <input type="text" name="Identifiant" id="Identifiant" value="{{$id}}" style="display: none;">
                    <label class="control-label">Borne Inferieur *</label>
                      <input type="text" name="borne_inf" class="form-control" id="borne_inf">
                      {!! $errors->first('borne_inf', '<span class="error">:message</span>') !!}
                  </div>
                  <div class="col-md-6">
                    <label class="control-label">Borne Superieur *</label>
                     <input type="text" name="borne_sup" class="form-control" id="borne_sup">
                      {!! $errors->first('borne_sup', '<span class="error">:message</span>') !!} 
                  </div>
                </div>
              </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
                <!-- END MODAL -->      
                </div>



                <!-- ============================================================== -->
                <!-- End PAge Content -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- Right sidebar -->
                <!-- ============================================================== -->
                <!-- .right-sidebar -->
                <!-- ============================================================== -->
                <!-- End Right sidebar -->
                <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->

                        @endsection

<script type="text/javascript">
  function getFourchette(va){
    var fourchette= $(va).val();
    $.get('{{route('getFourchetteId')}}',
    {fourchette:fourchette},
    function(data){
      var donnee = data.split("#");
      $("#Identifiant").val(fourchette);
      $("#borne_inf").val(donnee[0]);
      $("#borne_sup").val(donnee[1]);
    });
  }
</script>                        