@extends('layout.base')
@section('content')                        
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-header">
                <h3 class="card-title">Plan Analytique</h3>
                @can('compte_principal-create')
                <div class="row">
                  <div class="col-md-8"></div>
                  <div class="col-4">
                   <a href="javascript:void(0)" data-toggle="modal" data-target="#add-new-event" class="btn m-t-20 btn-info btn-block waves-effect waves-light">
                        <i class="ti-plus"></i> Nouvelle section
                    </a>
                  </div>
                </div>
                @endcan
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-striped">
                  <thead>
                    <tr>
                      <th>Numero</th>
                      <th>Intitulé</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  @foreach($Sections as $Compte)
                    <tr>
                      <td>{{$Compte->numero_compte}}</td>
                      <td>{{$Compte->section}}</td>
                    <td>
                      @can('compte_principal-edit')
                        <button data-toggle="modal" data-target="#add-older-event" value="{{$Compte->id}}" onclick="getCompteSection(this)">
                        <i class="fas fa-edit"></i>
                        </button>
                      @endcan
                      @can('compte_principal-delete')
                        <form action="{{route('Analytique.destroy', $Compte->id)}}" method='POST' style='display: inline-block;' onsubmit="return confirm('Etez-vous sur de cette Operation ?')">
                          {{csrf_field()}}
                          {{method_field('DELETE')}}
                          <button onclick="return confirm('Etez -vous sur de cette Operation ?')"><i class='fas fa-trash'></i>
                          </button>
                        </form>
                      @endcan
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</section></div>

                     <!-- Modal Add Category -->
                <div class="modal fade none-border" id="add-new-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Creer une Section</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('Analytique.store')}}">
                            <div class="modal-body">
                            {{ csrf_field() }}
                            <div class="row">
                              <div class="col-md-6">
                                <label class="control-label">Numero compte *</label>
                                <input class="form-control form-white" placeholder="Numero compte" type="text" name="Numero" />
                                {!! $errors->first('Numero', '<span class="error">:message</span>') !!}
                              </div>
                              <div class="col-md-6">  
                                <label class="control-label">Intitulé *</label>
                                <input class="form-control form-white" placeholder="Intitulé" type="text" name="Intitule" />
                                {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}
                              </div>

                            </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>

                <div class="modal fade none-border" id="add-older-event">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><strong>Modifier une Section</strong></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            </div>
                        <form method="POST" action="{{ route('UpdateSection')}}">
                            <div class="modal-body">
                               
                                    {{ csrf_field() }}
                                    {{ method_field('PUT') }}
                                    <div class="row">
                                        <input type="text" name="Identifiant" id="Identifiant" style="display: none;">
                                        <div class="col-md-12">
                                            <label class="control-label">Numero compte *</label>
                                            <input class="form-control form-white" placeholder="Numero compte" type="text" name="Numero" id="Numero" />
                                            {!! $errors->first('Numero', '<span class="error">:message</span>') !!}

                                            <label class="control-label">Intitulé *</label>
                                            <input class="form-control form-white" placeholder="Intitulé" type="text" name="Intitule" id="Intitule" />
                                            {!! $errors->first('Intitule', '<span class="error">:message</span>') !!}
                                        </div>
                                      </div>
                              </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary waves-effect waves-light save-category">Enregistrer</button>
                                <button type="reset" class="btn btn-secondary waves-effect" data-dismiss="modal">Annuler</button>
                            </div>
                           </form> 
                        </div>
                    </div>
                </div>
                <!-- END MODAL -->
                </div>



                <!-- ============================================================== -->
                <!-- End PAge Content -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- Right sidebar -->
                <!-- ============================================================== -->
                <!-- .right-sidebar -->
                <!-- ============================================================== -->
                <!-- End Right sidebar -->
                <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->

                        @endsection

<script type="text/javascript">
  function getCompteSection(va){
    var section= $(va).val();
    $.get('{{route('getCompteSection')}}',
    {section:section},
    function(data){
      var donnee = data.split("#");
      $("#Identifiant").val(compte);
      $("#Numero").val(donnee[0]);
      $("#Intitule").val(donnee[1]);
    });
  }
</script>                                  