<?php
 use App\Http\Middleware\ExerciceComptableExist;
 use App\Http\Middleware\InitialBilan;
 use App\Http\Middleware\CheckDatabaseConnection;
 use App\Http\Controllers\RoleController;
 use App\Http\Controllers\PermissionController;
 use App\Http\Controllers\CurrencyConverterController;
 use App\Http\Controllers\Auth\AuthController;
 use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

 // ROUTE POUR LA PAGE DE CONNEXION MST ET PARTENAIRE

Route::get('/', function () {
    return view('welcome');
});

Route::get('main-login', [AuthController::class, 'index'])->name('main_login');
Route::get('registration', [AuthController::class, 'registration'])->name('register');

Route::post('post-registration', [AuthController::class, 'postRegistration'])->name('register.post');  

Route::get('logout', [AuthController::class, 'logout'])->name('logout');


// MIDDLEWARE POUR VERIFIER SI LA BASE DE DONNEE EXISTES

Route::middleware([CheckDatabaseConnection::class])->group(function(){

Route::post('/file_upload', 'RepportageController@uploadfile')->name('uploadfile');
Route::post('post-login', [AuthController::class, 'postLogin'])->name('login.post'); 
//Route::post('/main/Verification', 'ConnexionController@Verification')->name('Verification');

Route::post('/main/VerifLogin', 'ConnexionController@VerifLogin')->name('VerifLogin');

Route::group(['middleware' => 'auth'], function(){

Route::get('/configuration_ms_syst', function () {
    return view('configuration');
})->name('configuration');

Route::get('/documentcomptable', function(){
    return view('documentcomptable');
})->name('documentcomptable');

Route::resource('Bien', 'bienController');
Route::resource('depreciationtype', 'depreciationtypeController');
Route::resource('sous_compte', 'SousCompteController');
Route::resource('Sclasse', 'SousClasseController');
Route::resource('Myfiles', 'MyfilesController');
Route::resource('NatureCompte', 'NatureCompteController');
Route::resource('Fourchette', 'FourchetteController');
Route::resource('Tiers', 'TierController');
Route::resource('Analytique', 'ControllersectionAnalytique');
Route::resource('Ventillation', 'ControllerVentillation');

//ASSISTANT DE SAUVEGARDE DE LA BASE DE DONNEES
Route::get('back_up_assistant', 'AdministrationController@back_up_assistant')->name('back_up_assistant');
Route::get('Back_up_store', 'AdministrationController@Back_up_store')->name('Back_up_store');

// GENERATION DES ETATS FINANCIERS

//1. Grand-Livre
Route::get('GrandLivre_form', 'EtatFinancierController@GrandLivre_form')->name('GrandLivre_form');
Route::get('edition_grand_livre', 'EtatFinancierController@edition_grand_livre')->name('edition_grand_livre');

//2.Balance

Route::get('Balance_form', 'EtatFinancierController@Balance_form')->name('Balance_form');
Route::get('edition_balance', 'EtatFinancierController@edition_balance')->name('edition_balance');

//3.Compte de resultat

Route::get('CompteResultat_form', 'EtatFinancierController@CompteResultat_form')->name('CompteResultat_form');
Route::get('edition_compte_resultat', 'EtatFinancierController@edition_compte_resultat')->name('edition_compte_resultat');

//4. Parametrage des etats financiers

Route::get('Add_EtatFinancier', 'ParametreEtatFinancier@Add_EtatFinancier')->name('Add_EtatFinancier');
Route::post('store_EtatFinancier', 'ParametreEtatFinancier@store_EtatFinancier')->name('store_EtatFinancier');
Route::delete('destroy_EtatFinancier/{id}', 'ParametreEtatFinancier@destroy_EtatFinancier')->name('destroy_EtatFinancier');
Route::get('show_EtatFinancier/{id}', 'ParametreEtatFinancier@show_EtatFinancier')->name('show_EtatFinancier');

// 4.1 Parametre des sections de etat financiers
Route::get('Add_Section/{etat}', 'ParametreEtatFinancier@Add_Section')->name('Add_Section');
Route::post('Section_store', 'ParametreEtatFinancier@Section_store')->name('Section_store');

//5.Bilan

Route::get('Bilan_form', 'EtatFinancierController@Bilan_form')->name('Bilan_form');
Route::get('edition_bilan', 'EtatFinancierController@edition_bilan')->name('edition_bilan');

Route::get('rapport_comptabilite', 'ComptabiliteController@rapport_comptabilite')->name('rapport_comptabilite');

Route::get('Cost_centered', 'ControllersectionAnalytique@Cost_centered')->name('Cost_centered');

Route::get('Cost_centered_edition', 'ControllersectionAnalytique@Cost_centered_edition')->name('Cost_centered_edition');
Route::get('Cash_flow_table', 'EtatFinancierController@Cash_flow_table')->name('Cash_flow_table');
Route::get('cash_flow_table_edition', 'EtatFinancierController@cash_flow_table_edition')->name('cash_flow_table_edition');

Route::post('AttachAccount', 'PartenaireController@AttachAccount')->name('AttachAccount');

Route::get('/details_bilan/{periode}/{compte}/{lien}', 'JournalController@details_bilan')->name('details_bilan');

Route::post('/depreciationForm', 'depreciationController@depreciationForm')->name('depreciationForm');
Route::get('/depreciationForm', 'depreciationController@depreciationForm')->name('depreciationForm');
Route::resource('depreciation', 'depreciationController');
Route::get('getTypeCompteId', 'TypeController@getTypeCompteId')->name('getTypeCompteId');

Route::get('/index', 'ComptabiliteController@index')->name('index');

Route::put('/update_result_configuration', 'JournalController@update_result_configuration')->name('update_result_configuration');
Route::get('/CorbUser', 'UtilisateurController@CorbUser')->name('CorbUser');
Route::get('/RestaurerUser/{User}', 'UtilisateurController@RestaurerUser')->name('RestaurerUser');
Route::resource('Utilisateurs', 'UtilisateurController');
Route::get('/restaureMotDePasse/{User}', 'UtilisateurController@restaureMotDePasse')->name('restaureMotDePasse');
Route::get('/ModifierMotdePasse', 'UtilisateurController@ModifierMotdePasse')->name('ModifierMotdePasse');
Route::put('/updateProfil', 'UtilisateurController@updateProfil')->name('updateProfil');


// ROUTES POUR LE MODULE DE COMPTABILITE

Route::get('/index', 'ComptabiliteController@index')->name('index');
 
Route::get('Balance', 'JournalController@Balance')->name('Balance');
Route::get('AfficherGdLivre', 'JournalController@AfficherGdLivre')->name('AfficherGdLivre');
Route::get('AfficherBalance', 'JournalController@AfficherBalance')->name('AfficherBalance');
Route::get('CompteResultat', 'JournalController@CompteResultat')->name('CompteResultat');
Route::get('Bilan', 'JournalController@Bilan')->name('Bilan');
Route::get('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
Route::post('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
 //});

Route::resource('CompteGeneral', 'CompteGeneralController');
Route::resource('Comptedivisionnaire', 'CompteSudbivisionnaireController');
Route::resource('ExerciceComptable', 'ExerciceComptableController');
Route::resource('TypeCompte', 'TypeController');
Route::resource('CodeJournaux','CodeJournauxController');
Route::resource('CompteJournal','CompteJournalController');
Route::resource('CompteRepport','CompteRepportController');
Route::resource('Parametre_generaux','ParametreController');
Route::resource('Repportage','RepportageController');


Route::get('Ventillation', 'ControllersectionAnalytique@Ventillation')->name('Ventillation');
Route::get('Liste_journal','CodeJournauxController@Liste_journal')->name('Liste_journal');

Route::get('apiCurrentConvert', [CurrencyConverterController::class, 'apiCurrentConvert'])->name('apiCurrentConvert');

Route::get('/uploadinjournalform', 'JournalController@uploadinjournalform')->name('uploadinjournalform');
Route::post('journal_file_upload', 'JournalController@journal_file_upload')->name('journal_file_upload');

Route::middleware([InitialBilan::class])->group(function(){
    Route::get('/uploadinitialbilanform', 'RepportageController@uploadinitialbilanform')->name('uploadinitialbilanform');
    Route::post('file_upload', 'RepportageController@uploadfile')->name('uploadfile');
});

Route::resource('Journal', 'JournalController');

Route::put('UpdateFourchette', 'FourchetteController@UpdateFourchette')->name('UpdateFourchette');
Route::put('UpdateCompteGeneral', 'CompteGeneralController@UpdateCompteGeneral')->name('UpdateCompteGeneral');
Route::put('UpdateCompteTiers', 'TierController@UpdateCompteTiers')->name('UpdateCompteTiers');
Route::put('UpdateSection', 'ControllersectionAnalytique@UpdateSection')->name('UpdateSection');
Route::put('UpdateNatureCompte', 'NatureCompteController@UpdateNatureCompte')->name('UpdateNatureCompte');

Route::put('UpdateCompteSudb', 'CompteSudbivisionnaireController@UpdateCompteSudb')->name('UpdateCompteSudb');
Route::put('UpdateSousCompte', 'SousCompteController@UpdateSousCompte')->name('UpdateSousCompte');

//Route::get('SaisieNouveauForm','RepportageController@SaisieNouveauForm')->name('SaisieNouveauForm');
Route::get('researchComptesReported', 'CompteRepportController@researchComptesReported')->name('researchComptesReported');
Route::get('PlanComptable', 'JournalController@PlanComptable')->name('PlanComptable');
Route::get('compte_general_nature/{id}', 'CompteGeneralController@compte_general_nature')->name('compte_general_nature');
Route::get('lastoperation', 'CompteGeneralController@lastoperation')->name('lastoperation');


Route::post('CloseExercice', 'ExerciceComptableController@CloseExercice')->name('CloseExercice');
Route::get('ReouvrirExercice/{ExerciceId}', 'ExerciceComptableController@ReouvrirExercice')->name('ReouvrirExercice');

Route::get('AddACount/{Journal}', 'CompteJournalController@AddACount')->name('AddACount');
Route::post('attachedAccount', 'CompteRepportController@attachedAccount')->name('attachedAccount');
Route::put('dettachedAccount', 'CompteRepportController@dettachedAccount')->name('dettachedAccount');
Route::get('SettedAccountAsRepported/{Compte}', 'CompteRepportController@SettedAccountAsRepported')->name('SettedAccountAsRepported');
Route::get('SettedAccountAsJournal/{Compte}', 'CodeJournauxController@SettedAccountAsJournal')->name('SettedAccountAsJournal');

Route::post('attachedJournal', 'CodeJournauxController@attachedJournal')->name('attachedJournal');
Route::put('dettacheJournal', 'CodeJournauxController@dettacheJournal')->name('dettacheJournal');
Route::get('getNatureCompteId', 'NatureCompteController@getNatureCompteId')->name('getNatureCompteId');
Route::get('getPermissionId', 'PermissionController@getPermissionId')->name('getPermissionId');

Route::get('getFourchetteId', 'FourchetteController@getFourchetteId')->name('getFourchetteId');

Route::get('getCompteGeneralId', 'CompteGeneralController@getCompteGeneralId')->name('getCompteGeneralId');
Route::get('getCompteTiersId', 'TierController@getCompteTiersId')->name('getCompteTiersId');
Route::get('getCompteSection', 'ControllersectionAnalytique@getCompteSection')->name('getCompteSection');
Route::get('show_section/{id}', 'ParametreEtatFinancier@show_section')->name('show_section');
Route::delete('delete_section/{id}', 'ParametreEtatFinancier@delete_section')->name('delete_section');
Route::get('TransfererCompta/{ligne}', 'bienController@TransfererCompta')->name('TransfererCompta');
Route::get('Amortissement_sous_compte/{Compte}', 'CompteSudbivisionnaireController@Amortissement_sous_compte')->name('Amortissement_sous_compte');
Route::get('PlanAmortissement', 'depreciationController@PlanAmortissement')->name('PlanAmortissement');
Route::get('getSClasseId', 'SousClasseController@getSClasseId')->name('getSClasseId');

Route::get('getRepportageId', 'RepportageController@getRepportageId')->name('getRepportageId');
Route::put('depreciationtypeupdate', 'depreciationtypeController@depreciationtypeupdate')->name('depreciationtypeupdate');
Route::get('soldeJournalierForm', 'SoldeJournalierController@soldeJournalierForm')->name('soldeJournalierForm');
Route::put('SoldeJournalierAccount', 'SoldeJournalierController@SoldeJournalierAccount')->name('SoldeJournalierAccount');
Route::get('SoldeJournalier', 'SoldeJournalierController@SoldeJournalier')->name('SoldeJournalier');
Route::get('getSolde', 'SoldeJournalierController@getSolde')->name('getSolde');
Route::get('/solde_detail/{account}/{period}', 'SoldeJournalierController@solde_detail')->name('solde_detail');
Route::resource('SoldeJour', 'SoldeJournalierController');

Route::resource('guichet', 'GuichetController');
Route::get('Brouillard', 'JournalController@Brouillard')->name('Brouillard'); 
Route::post('repportage_store_configuration', 'ParametreController@repportage_store_configuration')->name('repportage_store_configuration');

//ROUTES POUR LA GESTION DES DROITS D'ACCESS AU SYSTEME MS
    Route::resource('modules', 'ModuleController');
    Route::resource('roles', 'RoleController');
    Route::resource('permissions', 'PermissionController');
    Route::post('add_permission', 'UtilisateurController@add_permission')->name('add_permission');



    Route::put('UpdatePermission', 'PermissionController@UpdatePermission')->name('UpdatePermission');
});

});


