<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Tier;
use App\Models\CompteGeneral;
class TierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Tiers = Tier::all();
        $NatureComptes = CompteGeneral::whereEtat(0)->get();
        return view('Comptabilite/Tiers.index', compact('Tiers', 'NatureComptes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Tier::create([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'Compte_id'=>$request->Compte_id,
            'Tier_type'=>$request->Tier_type
        ]);

        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


     public function getCompteTiersId(Request $request){
        $compteId = $request->get('compte');
        $Compte = Tier::findOrFail($compteId);
        $NatureComptes = CompteGeneral::whereEtat(0)->get();
 
        $Tiers = "<label class='control-label'>Tiers *</label>
                    <select class='form-control select2' name='Tier_type'>
                        <option value=".$Compte->Tier_type.">".$Compte->Tier_type."</option>
                        <option value='Client'>Client</option>
                        <option value='Fournisseur'>Fournisseur</option>
                        <option value='Salarié'>Salarié</option>
                        <option value='Actionnaire'>Actionnaire</option>
                    </select>
                    {!! $errors->first('Tier_type', '<span class='error'>:message</span>') !!}";

        $Compte_G="<label class='control-label'>Compte Géneral *</label>
                    <select class='form-control select2' name='Compte_id'>
                    <option value=".$Compte->compte_id."></option>";
                       foreach($NatureComptes as $NatureCompte){
                        $Compte_G.="<option value=".$NatureCompte->id.">".$NatureCompte->NumeroCompte." -- ".$NatureCompte->Intitule."</option>";
                       }  
                    $Compte_G.="</select>
                    {!! $errors->first('Compte_id', '<span class='error'>:message</span>') !!}";


        $Input = $Compte->numero_compte.'#'.$Compte->Intitule.'#'.$Tiers.'#'.$Compte_G;
    
        echo  $Input;
    }

    public function UpdateCompteTiers(Request $request){
        $Compte = Tier::findOrFail($request->Identifiant);
        
            $Compte->update([
                'NumeroCompte'=>$request->NumeroCompte,
                'Intitule'=>$request->Intitule,
                'Compte_id'=>$request->Compte_id,
                'Tier_type'=>$request->Tier_type
            ]);
    }
}
