<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use App\Models\Module;
use DB;
class PermissionController extends Controller
{   
    function __construct()
    {
         // $this->middleware('permission:permission-list|permission-create|permission-edit|permission-delete', ['only' => ['index','store']]);
         // $this->middleware('permission:permission-create', ['only' => ['create','store']]);
         // $this->middleware('permission:permission-edit', ['only' => ['edit','update']]);
         // $this->middleware('permission:permission-delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Permission::all();
        $modules = Module::all();
        return view('permissions.index', compact('data', 'modules'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('permissions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:permissions,name',
        ]);
    
        Permission::create(['name' => $request->input('name'), 'module_id' => $request->input('module_id')]);
    
        return redirect()->route('permissions.index')
            ->with('success', 'Permission created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $permission = Permission::find($id);
    
        return view('permissions.show', compact('permission'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $permission = Permission::find($id);
    
        return view('permissions.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);
    
        $permission = Permission::find($id);
        $permission->name = $request->input('name');
        $permission->save();
        
        return redirect()->route('permissions.index')
            ->with('success', 'Permission updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Permission::find($id)->delete();
        
        return redirect()->route('permissions.index')
            ->with('success', 'Permission deleted successfully');
    }

        public function getPermissionId(Request $request){
        $Modules = Module::all();
        $PermissionId = $request->get('permission');
        $Perm =DB::table('permissions')
                ->join('modules', 'modules.id', '=', 'permissions.module_id')
                ->select(DB::raw('permissions.name, modules.id, modules.module'))
                ->where('permissions.id', $PermissionId)->first();

        $Modu ='<option value='.$Perm->id.'>'.$Perm->module.'</option>';

            foreach($Modules as $Module){
                    $Modu.='<option value='.$Module->id.'>'.$Module->module.'</option>';
            }      
        
        $TypeDetail =  $Perm->name.'#'.$Modu;
        echo  $TypeDetail;
    }


    public function UpdatePermission(Request $request){
        $Permiss = Permission::findOrFail($request->Identifiant);
        
            $Permiss->update([
                'module_id'=>$request->Module,
                'name'=>$request->Permission,
            ]);
        return back();
    }
}
