<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\EtatFinanciers;
use App\Models\sectionEtatFinancier;
use App\Models\EtatFinancierContent;
use App\Models\CompteGeneral;
use DB;
class ParametreEtatFinancier extends Controller
{
    public function Add_EtatFinancier(){
        $EtatFinanciers = EtatFinanciers::all();
        return view('Comptabilite/Etats.Add_EtatFinancier', compact('EtatFinanciers'));
    }

    public function store_EtatFinancier(Request $request){
        EtatFinanciers::create([
            'intitule'=>$request->intitule,
            'type_etat'=>$request->type_etat
        ]);
        return back();
    }

    public function show_EtatFinancier($id){
        $Sections = EtatFinanciers::whereTypeEtat($id)->get();
        return view('Comptabilite/Etats.show_EtatFinancier', compact('Sections', 'id'));
    }

    public function Add_Section($id){
        $CompteGenerals = CompteGeneral::all();
        return view('Comptabilite/Etats.Section_Bilan', compact('id', 'CompteGenerals'));

    }

    public function Section_store(Request $request){
        $comptes = $request['compte'];
        $contents = $request['content_id'];
        $i=0;
       
        if (isset($request->Ajouter)) {
            if ($request['compte']!=0) {
                for ($i=0; $i <count($request['compte']) ; $i++){ 
                    $compte = (int)$comptes[$i];
                    EtatFinancierContent::create([
                        'sous_rubrique_id'=>$request->sous_rubrique,
                        'compte_id'=>$compte
                    ]);
                }    
            }else{
                session()->flash('messageDelete', 'attaché au moins un compte');
            }
        }elseif(isset($request->Supprimer)){
            if ($request['content_id']!=0) {
                for ($i=0; $i <count($request['content_id']) ; $i++){ 
                    $content = EtatFinancierContent::findOrFail((int)$contents[$i]);
                    $content->destroy((int)$contents[$i]);
                } 
            }else{
                session()->flash('messageDelete', 'attaché au moins un compte');
            }

        }else{

            if ($request['compte']!=0) {
                EtatFinanciers::create([
                    'intitule'=>$request->sous_rubrique,
                    'type_etat'=>$request->etat,
                    'Section'=>$request->Section,
                    'Positionnement'=>$request->Position
                ]);

                $lastOne = DB::table('etat_financiers')->latest('id')->first();
                    for ($i=0; $i <count($request['compte']) ; $i++) { 
                        $compte = (int)$comptes[$i];
                        EtatFinancierContent::create([
                            'sous_rubrique_id'=>$lastOne->id,
                            'compte_id'=>$compte
                        ]);
                    } 
            }else{
                session()->flash('messageDelete', 'attaché au moins un compte');
            }
        }
        return back();   
    }

    public function delete_section($id){
        $Contents = EtatFinancierContent::whereSousRubriqueId($id)->get();
        foreach ($Contents as $key => $value) {
            $Content = EtatFinancierContent::findOrFail($value->id);
            $Content->destroy($value->id);
        }
        $Section = EtatFinanciers::findOrFail($id);
        $Section->destroy($id);
        return back();
    }

    public function show_section($id){
        $table='';
        $Comptes = CompteGeneral::all();

        foreach ($Comptes as $key => $value) {
            $Content = EtatFinancierContent::whereSousRubriqueIdAndCompteId($id,$value->id)->first();
        if (!is_null($Content)) {

                $table.="<tr><td><input type='checkbox' class='compteChecked' checked='checked' name='content_id[]' value=".$Content->id."></td>";
            }else{
                $table.="<td><input type='checkbox' class='compteChecked' name='compte[]' value=".$value->id."></td>";
            }

                $table.="<td>".$value->numero_compte."</td>
                      <td>".$value->Intitule."</td></tr>";
         }
        return view('Comptabilite/Etats.show_section',compact('table', 'id'));         
    }
}
