<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Parametre;
use App\Http\Requests;
use App\Models\CompteGeneral;
use App\Models\CodeJournaux;
use App\Http\Requests\ParametreFormRequest;
class ParametreController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $CompteGenerals = CompteGeneral::whereEtat(0)->get();
        $Journals = CodeJournaux::whereEtat(0)->get();
        
        $resultat = CompteGeneral::where('resultat_exercice', '=',1)->Orwhere('Repport', '=',1)->Orwhere('Repport', '=', 2)->get();
        $repport = CodeJournaux::where('ANouveau', '=', 1)->get();
        $param = Parametre::first();
        if (!is_null($param)) {
            $Parametre = Parametre::findOrFail($param->id);
        }else{
           $Parametre = NEW Parametre;
        }
        return view('Comptabilite/Parametre.create', compact('Parametre', 'CompteGenerals', 'Journals', 'resultat', 'repport'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $Parameter = Parametre::first();
        $Parametre = Parametre::findOrFail($Parameter->id);
        
         $Headerfile = $request->file('entete');
        $Footerfile = $request->file('footer');
        $Header ='images/'.$Headerfile->getClientOriginalName();
        $Footer ='images/'. $Footerfile->getClientOriginalName();

        if (($Headerfile->move('images', $Header)) AND ($Footerfile->move('images', $Footer))) {
/*        $Parametre->update([
            'nom_societe'=>$request->Nom,
            'nif'=>$request->Nif,
            'email'=>$request->email,
            'telephone'=>$request->telephone,
            'adresse'=>$request->adresse,
            'bq_nom_un'=>$request->first_banque_name,
            'bq_num_un'=>$request->first_banque_number,
            'bq_nom_deux'=>$request->second_banque_name,
            'bq_num_deux'=>$request->second_banque_number,
            'longueur_compte'=>$request->LongeurCompte
        ]);*/

         $Parametre->update([
            'nom_societe'=>$request->Nom,
            'nif'=>$request->Nif,
            'email'=>$request->email,
            'telephone'=>$request->telephone,
            'adresse'=>$request->adresse,
            'bq_nom_un'=>$request->first_banque_name,
            'bq_num_un'=>$request->first_banque_number,
            'bq_nom_deux'=>$request->second_banque_name,
            'bq_num_deux'=>$request->second_banque_number,
            'entete'=>$Header,
            'footer'=>$Footer,
            'longueur_compte'=>$request->LongeurCompte
        ]);
      }

        $InfoGeneral = Parametre::first();
            if (!is_null($InfoGeneral)) {
                $request->session()->put('Nom_Societe', $InfoGeneral->nom_societe);
                $request->session()->put('Nif', $InfoGeneral->nif);
                $request->session()->put('email', $InfoGeneral->email);
                $request->session()->put('Telephone', $InfoGeneral->telephone);
                $request->session()->put('Adresse', $InfoGeneral->adresse);
                $request->session()->put('BqnomUn', $InfoGeneral->bq_nom_un);
                $request->session()->put('BqnumUn', $InfoGeneral->bq_num_un);
                $request->session()->put('BqnomDeux', $InfoGeneral->bq_nom_deux);
                $request->session()->put('BqnumDeux', $InfoGeneral->bq_num_deux);
                $request->session()->put('longeur', $InfoGeneral->longueur_compte);
                $request->session()->put('Headerfile', $InfoGeneral->entete);
                $request->session()->put('Footerfile', $InfoGeneral->footer);
            }else{
                $request->session()->put('Nom_Societe', "");
                $request->session()->put('Nif', "");
                $request->session()->put('email', "");
                $request->session()->put('Telephone', "");
                $request->session()->put('Adresse', "");
                $request->session()->put('BqnomUn', "");
                $request->session()->put('BqnumUn', "");
                $request->session()->put('BqnomDeux', "");
                $request->session()->put('BqnumDeux', "");
                $request->session()->put('longeur_compte', 6);
                $request->session()->put('Headerfile', "");
                $request->session()->put('Footerfile', "");
            }
        return redirect(route('Parametre_generaux.create'));
    }

    public function repportage_store_configuration(Request $request){

        $values=array('resultat_exercice'=>NULL,'Repport'=>NULL);
        CompteGeneral::where('resultat_exercice','!=', NULL)->Orwhere('Repport','!=', NULL)->update($values);

        $resultat = CompteGeneral::findOrFail($request->resultat);

        $resultat->update([
            'resultat_exercice'=>1
        ]);

        $repportnouveauben = CompteGeneral::findOrFail($request->repportnouveauben);

        $repportnouveauben->update([
            'Repport'=>1
        ]);

        $repportnouveaudef = CompteGeneral::findOrFail($request->repportnouveaudef);

        $repportnouveaudef->update([
            'Repport'=>2
        ]);

        $values=array('ANouveau'=>NULL);
        CodeJournaux::where('ANouveau','!=', NULL)->update($values);

        $Journal = CodeJournaux::findOrFail($request->repport_j);
        $Journal->update([
            'ANouveau'=>1
        ]);

        return back();

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ParametreFormRequest $request, $id)
    {   

        $Nbre = Parametre::whereId($id)->count('id');
        if ($Nbre>0) {
            $Parametre = Parametre::findOrFail($id);
        }else{
           $Parametre = NEW Parametre;
        }

        $Headerfile = $request->file('entete');
        $Footerfile = $request->file('footer');
        $Header ='images/'.$Headerfile->getClientOriginalName();
        $Footer ='images/'. $Footerfile->getClientOriginalName();

        if (($Headerfile->move('images', $Header)) AND ($Footerfile->move('images', $Footer))) {
    
        $Parametre->update([
            'nom_societe'=>$request->Nom,
            'nif'=>$request->Nif,
            'email'=>$request->email,
            'telephone'=>$request->telephone,
            'adresse'=>$request->adresse,
            'bq_nom_un'=>$request->first_banque_name,
            'bq_num_un'=>$request->first_banque_number,
            'bq_nom_deux'=>$request->second_banque_name,
            'bq_num_deux'=>$request->second_banque_number,
            'entete'=>$Header,
            'footer'=>$Footer,
            'longueur_compte'=>$request->LongeurCompte
        ]);
      }

              $InfoGeneral = Parametre::where('entete', '!=', '')->where('footer', '!=', null)->first();
                $request->session()->put('Nom_Societe', $InfoGeneral->nom_societe);
                $request->session()->put('Nif', $InfoGeneral->nif);
                $request->session()->put('email', $InfoGeneral->email);
                $request->session()->put('Telephone', $InfoGeneral->telephone);
                $request->session()->put('Adresse', $InfoGeneral->adresse);
                $request->session()->put('BqnomUn', $InfoGeneral->bq_nom_un);
                $request->session()->put('BqnumUn', $InfoGeneral->bq_num_un);
                $request->session()->put('BqnomDeux', $InfoGeneral->bq_nom_deux);
                $request->session()->put('BqnumDeux', $InfoGeneral->bq_num_deux);
                $request->session()->put('Headerfile', $InfoGeneral->entete);
                $request->session()->put('Footerfile', $InfoGeneral->footer);
                $request->session()->put('Footerfile', $InfoGeneral->footer);
                $request->session()->put('longeur', $InfoGeneral->longueur_compte);


        return redirect(route('Parametre_generaux.edit', compact('id')));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
