<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\CompteGeneral;
use App\Models\CodeJournaux;
use DB;
use PDF;
use App\Models\EtatFinanciers;
class EtatFinancierController extends Controller
{   
    public function GrandLivre_form(){
        $Comptes = CompteGeneral::all();
        $Codes = CodeJournaux::all();
    	return view('Comptabilite/Etats.GrandLivre_form', compact('Comptes', 'Codes'));
    }

    public function Balance_form(){
    	$Comptes = CompteGeneral::all();
    	$Codes = CodeJournaux::all();
    	return view('Comptabilite/Etats.Balance_form', compact('Comptes', 'Codes'));
    }

    public function Cash_flow_table(){
      $Comptes = CompteGeneral::all();
      $Codes = CodeJournaux::all();
      return view('Comptabilite/Etats.Cash_flow_table_form', compact('Comptes', 'Codes'));
    }

    public function edition_grand_livre(){
      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = "Journal de Situation exclus";

      $deb_c = intval($_GET['CompteFrom']);
      $end_c = intval($_GET['CompteTo']);
      $deb_j = intval($_GET['JournalFrom']);
      $end_j = intval($_GET['JournalTo']);

      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo'])) {
          $compte_debut = CompteGeneral::findOrFail($_GET['CompteFrom']);
          $compte_fin = CompteGeneral::findOrFail($_GET['CompteTo']);
          $EchelonCompt ='Compte de '.$compte_debut->numero_compte.' à '.$compte_fin->numero_compte;
      }

      if (!empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo'])) {
          $journal_debut = CodeJournaux::findOrFail($_GET['JournalFrom']);
          $journal_fin = CodeJournaux::findOrFail($_GET['JournalTo']);
          $EchelonJour ='Journal de '.$journal_debut->Code.' à '.$journal_fin->Code;
      }

      if (!empty($_GET['Situation'])) {
         $IncludeSituation = "Journal de Situation inclus";
      }
       

      $TMD=0;
      $TMC=0;
      $TSNet=0;
      $table = "";
        
      // FILTRAGE 
      //1. FILTRAGE PAR TOUTES LES CONDITIONS POSSIBLES
      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND !empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND !empty($_GET['Situation'])) {

        $Comptes = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->join('journal_mensuelles', 'journal_mensuelles.id', '=','journals.journal_id')
          ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
          ->whereBetween('journals.Compte', [$deb_c, $end_c])
          ->whereBetween('journal_mensuelles.journal_id', [$deb_j, $end_j])
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->groupBy('compte_generals.id')
          ->get();
        foreach ($Comptes as $Compte) {
          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                <td colspan='1'>".$Compte->TD."</td>
                <td colspan='1'>".$Compte->TC."</td>
                <td colspan='1'>".$Compte->SNet."</td>
              </tr>";   

          $Ecritures = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
            ->whereBetween('journals.Compte', [$deb_c, $end_c])
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j, $end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('journals.Compte',$Compte->id)
            ->get();

            foreach ($Ecritures as $Ecriture) {
              $table.="<tr style='background-color:white;'>
                <td>".$Ecriture->DateOp."</td>
                <td>".$Ecriture->Code."</td>
                <td>".$Ecriture->Piece."</td>
                <td>".$Ecriture->Libelle."</td>
                <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
              </tr>"; 
            }
            $TMD+=$Compte->TD;
            $TMC+=$Compte->TC;
            $TSNet+=$Compte->SNet;
          }
        }

        //2. AUCUNE CONDITION N'EST MENTIONNER SAUF LES DATES
        if (empty($_GET['CompteFrom']) AND empty($_GET['CompteTo']) AND empty($_GET['JournalFrom']) AND empty($_GET['JournalTo']) AND empty($_GET['Situation'])) {

          $Comptes = DB::table('compte_generals')
            ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->groupBy('compte_generals.id')
            ->get();
            foreach ($Comptes as $Compte) {
              $table.="
                <tbody>
                  <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                    <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                    <td colspan='1'>".$Compte->TD."</td>
                    <td colspan='1'>".$Compte->TC."</td>
                    <td colspan='1'>".$Compte->SNet."</td>
                  </tr>";   

              $Ecritures = DB::table('journals')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('code_journauxes.ANouveau', null)
                ->where('journals.Compte',$Compte->id)
                ->get();

              foreach ($Ecritures as $Ecriture) {
                $table.="<tr style='background-color:white;'>
                  <td>".$Ecriture->DateOp."</td>
                  <td>".$Ecriture->Code."</td>
                  <td>".$Ecriture->Piece."</td>
                  <td>".$Ecriture->Libelle."</td>
                  <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                  <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                  <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                </tr>"; 
              }
              $TMD+=$Compte->TD;
              $TMC+=$Compte->TC;
              $TSNet+=$Compte->SNet;
            }
          }

        //3. TRIAGE PAR RAPPORT AUX COMPTES
        if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND (empty($_GET['JournalFrom']) OR empty($_GET['JournalTo']))) {
          if (!empty($_GET['Situation'])) {
            $Comptes = DB::table('compte_generals')
              ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
              ->whereBetween('journals.Compte', [$deb_c,$end_c])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->groupBy('compte_generals.id')
              ->get();
          }else{
            $Comptes = DB::table('compte_generals')
              ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
              ->whereBetween('journals.Compte', [$deb_c,$end_c])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau', null)
              ->groupBy('compte_generals.id')
              ->get();
          }
            
          foreach ($Comptes as $Compte) {
            
            $table.="
              <tbody>
                <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                <td colspan='1'>".$Compte->TD."</td>
                <td colspan='1'>".$Compte->TC."</td>
                <td colspan='1'>".$Compte->SNet."</td>
                </tr>";   
                
            if (!empty($_GET['Situation'])) {
              $Ecritures = DB::table('journals')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                ->whereBetween('journals.Compte', [$deb_c,$end_c])
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('journals.Compte',$Compte->id)
                ->get();
            }else{
              $Ecritures = DB::table('journals')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                ->whereBetween('journals.Compte', [$deb_c,$end_c])
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('journals.Compte',$Compte->id)
                ->where('code_journauxes.ANouveau', null)
                ->get();
            }
            foreach ($Ecritures as $Ecriture) {
              $table.="<tr style='background-color:white;'>
                <td>".$Ecriture->DateOp."</td>
                <td>".$Ecriture->Code."</td>
                <td>".$Ecriture->Piece."</td>
                <td>".$Ecriture->Libelle."</td>
                <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
              </tr>"; 
            }
            $TMD+=$Compte->TD;
            $TMC+=$Compte->TC;
            $TSNet+=$Compte->SNet;
          }
        }

        //4. TRIAGE PAR RAPPORT AUX JOURNAUX
        if (!empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND (empty($_GET['CompteFrom']) OR empty($_GET['CompteTo']))) {

          if (!empty($_GET['Situation'])) {
            $Comptes = DB::table('compte_generals')
              ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
              ->whereBetween('journal_mensuelles.journal_id', [$deb_j, $end_j])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->groupBy('compte_generals.id')
              ->get();
          }else{
            $Comptes = DB::table('compte_generals')
              ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
              ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau', null)
              ->groupBy('compte_generals.id')
              ->get();
          }    
          foreach ($Comptes as $Compte) {
            
            $table.="
              <tbody>
                <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                  <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                  <td colspan='1'>".$Compte->TD."</td>
                  <td colspan='1'>".$Compte->TC."</td>
                  <td colspan='1'>".$Compte->SNet."</td>
                  </tr>";   
                
            if (!empty($_GET['Situation'])) {
              $Ecritures = DB::table('journals')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('journals.Compte',$Compte->id)
                ->get();
            }else{
              $Ecritures = DB::table('journals')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('journals.Compte',$Compte->id)
                ->where('code_journauxes.ANouveau', null)
                ->get();
            }

                foreach ($Ecritures as $Ecriture) {
                    $table.="<tr style='background-color:white;'>
                        <td>".$Ecriture->DateOp."</td>
                        <td>".$Ecriture->Code."</td>
                        <td>".$Ecriture->Piece."</td>
                        <td>".$Ecriture->Libelle."</td>
                        <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                    </tr>"; 
                }
                $TMD+=$Compte->TD;
                $TMC+=$Compte->TC;
                $TSNet+=$Compte->SNet;
            }
          }


        //5. FILTRAGE PAR TOUTES LES CONDITIONS POSSIBLES SAUF INCLUSION DU JOURNAL DE SITUATION
        if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND !empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND empty($_GET['Situation'])) {

            $Comptes = DB::table('compte_generals')
                ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
                ->whereBetween('journals.Compte', [$deb_c, $end_c])
                ->whereBetween('journal_mensuelles.journal_id', [$deb_j, $end_j])
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->where('code_journauxes.ANouveau', null)
                ->groupBy('compte_generals.id')
                ->get();


            foreach ($Comptes as $Compte) {
            
                $table.="
                    <tbody>
                      <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                        <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                        <td colspan='1'>".$Compte->TD."</td>
                        <td colspan='1'>".$Compte->TC."</td>
                        <td colspan='1'>".$Compte->SNet."</td>
                      </tr>";   

                $Ecritures = DB::table('journals')
                  ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                  ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                  ->whereBetween('journals.Compte', [$deb_c, $end_c])
                  ->whereBetween('journal_mensuelles.journal_id', [$deb_j, $end_j])
                  ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                  ->where('code_journauxes.ANouveau', null)
                  ->where('journals.Compte',$Compte->id)
                  ->get();

                foreach ($Ecritures as $Ecriture) {
                    $table.="<tr style='background-color:white;'>
                        <td>".$Ecriture->DateOp."</td>
                        <td>".$Ecriture->Code."</td>
                        <td>".$Ecriture->Piece."</td>
                        <td>".$Ecriture->Libelle."</td>
                        <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                    </tr>"; 
                }
                $TMD+=$Compte->TD;
                $TMC+=$Compte->TC;
                $TSNet+=$Compte->SNet;
            }
          }

        //6. FILTRAGE RIEN QUE PAR INCLUSION DU JOURNAL DE SITUATION
        if (empty($_GET['CompteFrom']) AND empty($_GET['CompteTo']) AND empty($_GET['JournalFrom']) AND empty($_GET['JournalTo']) AND !empty($_GET['Situation'])) {

            $Comptes = DB::table('compte_generals')
                ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
                ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule, sum(journals.MD) as TD, sum(journals.MC) as TC,compte_generals.id,sum(journals.MD)-sum(journals.MC) as SNet'))
                ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                ->groupBy('compte_generals.id')
                ->get();
            foreach ($Comptes as $Compte) {
            
                $table.="
                    <tbody>
                      <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                        <td colspan='4'>".$Compte->numero_compte.' '.$Compte->Intitule."</td>
                        <td colspan='1'>".$Compte->TD."</td>
                        <td colspan='1'>".$Compte->TC."</td>
                        <td colspan='1'>".$Compte->SNet."</td>
                      </tr>";   

                $Ecritures = DB::table('journals')
                  ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
                  ->select(DB::raw('code_journauxes.Code,journals.Piece,journals.Libelle,journals.MD,journals.MC,DATE_FORMAT(journals.DateOperation, "%d%m%Y") as DateOp, (journals.MD)-(journals.MC) as NetM'))
                  ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
                  ->where('journals.Compte',$Compte->id)
                  ->get();

                foreach ($Ecritures as $Ecriture) {
                    $table.="<tr style='background-color:white;'>
                        <td>".$Ecriture->DateOp."</td>
                        <td>".$Ecriture->Code."</td>
                        <td>".$Ecriture->Piece."</td>
                        <td>".$Ecriture->Libelle."</td>
                        <td>".number_format($Ecriture->MD,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->MC,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                        <td>".number_format($Ecriture->NetM,session()->get('ExerciceNbreDecimal'),session()->get('ExerciceSeparateurDecimal'),session()->get('ExerciceseparateurMilieu')).' '.session()->get('ExerciceDevise')."</td>
                    </tr>"; 
                }
                $TMD+=$Compte->TD;
                $TMC+=$Compte->TC;
                $TSNet+=$Compte->SNet;
            }
          }  
          
        $table.="
            <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='4'>TOTAL Grand-Livre</td>
                <td colspan='1'>".$TMD."</td>
                <td colspan='1'>".$TMC."</td>
                <td colspan='1'>".$TSNet."</td>
            </tr>";   
      return view('Comptabilite.GrandLivre', compact('table', 'Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));   
    }


    public function edition_balance(){
    
      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = "Journal de Situation exclus";

      $deb_c = intval($_GET['CompteFrom']);
      $end_c = intval($_GET['CompteTo']);
      $deb_j = intval($_GET['JournalFrom']);
      $end_j = intval($_GET['JournalTo']);

      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo'])) {
          $compte_debut = CompteGeneral::findOrFail($_GET['CompteFrom']);
          $compte_fin = CompteGeneral::findOrFail($_GET['CompteTo']);
          $EchelonCompt ='Compte de '.$compte_debut->numero_compte.' à '.$compte_fin->numero_compte;
      }

      if (!empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo'])) {
          $journal_debut = CodeJournaux::findOrFail($_GET['JournalFrom']);
          $journal_fin = CodeJournaux::findOrFail($_GET['JournalTo']);
          $EchelonJour ='Journal de '.$journal_debut->Code.' à '.$journal_fin->Code;
      }

      if (!empty($_GET['Situation'])) {
         $IncludeSituation = "Journal de Situation inclus";
      }

         
      $SDB=0;
      $SCD=0;
      $TSDB=0;
      $TSCD=0;
      $TAND = 0;
      $TANC = 0;
      $TD = 0;
      $TC = 0;
      $table = '';


      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND !empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND !empty($_GET['Situation'])) {

        $Comptes = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
          ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
          ->whereBetween('journals.Compte', [$deb_c,$end_c])
          ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->groupBy('compte_generals.id')
          ->get();
        foreach ($Comptes as $Compte) {

          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('journals.Compte', $Compte->id)
            ->where('code_journauxes.ANouveau',NULL)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',NULL)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC');            

          $AnouveauD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',1)
            ->where('journals.Compte',$Compte->id)
            ->sum('journals.MD');

          $AnouveauC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',1)
            ->where('journals.Compte',$Compte->id)
            ->sum('journals.MC');  

          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }

      //2. AUCUNE CONDITION N'EST MENTIONNE SAUF LES DATES
      if (empty($_GET['CompteFrom']) AND empty($_GET['CompteTo']) AND empty($_GET['JournalFrom']) AND empty($_GET['JournalTo']) AND empty($_GET['Situation'])) {

        $Comptes = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
          ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
          ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->where('code_journauxes.ANouveau', null)
          ->groupBy('compte_generals.id')
          ->get();

        foreach ($Comptes as $Compte) {
          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('journals.Compte', $Compte->id)
            ->where('code_journauxes.ANouveau',null)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC');            

          $AnouveauD = 0;
          $AnouveauC = 0;  

          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }

      //3. TRIAGE PAR RAPPORT AUX COMPTES
      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND (empty($_GET['JournalFrom']) OR empty($_GET['JournalTo']))) {
        
        if (!empty($_GET['Situation'])) {
          $Comptes = DB::table('compte_generals')
            ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->groupBy('compte_generals.id')
            ->get();
        }else{
          $Comptes = DB::table('compte_generals')
            ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->groupBy('compte_generals.id')
            ->get();
          
        }
        foreach ($Comptes as $Compte) {
          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('journals.Compte', $Compte->id)
            ->where('code_journauxes.ANouveau',null)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC'); 

          if (!empty($_GET['Situation'])) {
            $AnouveauD = DB::table('journals')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw(''))
              ->whereBetween('journals.Compte', [$deb_c,$end_c])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau',1)
              ->where('journals.Compte',$Compte->id)
              ->sum('journals.MD');

            $AnouveauC = DB::table('journals')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw(''))
              ->whereBetween('journals.Compte', [$deb_c,$end_c])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau',1)
              ->where('journals.Compte',$Compte->id)
              ->sum('journals.MC');  

          }else{
            $AnouveauD=0;
            $AnouveauC=0;
          }
          
          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }

      //4. TRIAGE PAR RAPPORT AUX JOURNAUX
      if (!empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND (empty($_GET['CompteFrom']) OR empty($_GET['CompteTo']))) {
 
        if (!empty($_GET['Situation'])) {
          $Comptes = DB::table('compte_generals')
            ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->groupBy('compte_generals.id')
            ->get();
        }else{
          $Comptes = DB::table('compte_generals')
            ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->groupBy('compte_generals.id')
            ->get();
          
        }
        foreach ($Comptes as $Compte) {
          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('journals.Compte', $Compte->id)
            ->where('code_journauxes.ANouveau',null)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC'); 

          if (!empty($_GET['Situation'])) {
            $AnouveauD = DB::table('journals')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw(''))
              ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau',1)
              ->where('journals.Compte',$Compte->id)
              ->sum('journals.MD');

            $AnouveauC = DB::table('journals')
              ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
              ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
              ->select(DB::raw(''))
              ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
              ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
              ->where('code_journauxes.ANouveau',1)
              ->where('journals.Compte',$Compte->id)
              ->sum('journals.MC');  

          }else{
            $AnouveauD=0;
            $AnouveauC=0;
          }
          
          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }


      //5. FILTRAGE PAR TOUTES LES CONDITIONS POSSIBLES SAUF INCLUSION DU JOURNAL DE SITUATION
      if (!empty($_GET['CompteFrom']) AND !empty($_GET['CompteTo']) AND !empty($_GET['JournalFrom']) AND !empty($_GET['JournalTo']) AND empty($_GET['Situation'])) {

        $Comptes = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
          ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
          ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
          ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
          ->whereBetween('journals.Compte', [$deb_c,$end_c])
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->where('code_journauxes.ANouveau', null)
          ->groupBy('compte_generals.id')
          ->get();
          
        foreach ($Comptes as $Compte) {
          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journal_mensuelles.journal_id', [$deb_j,$end_j])
            ->whereBetween('journals.Compte', [$deb_c,$end_c])
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC'); 

          $AnouveauD =0;
          $AnouveauC =0;  
        
          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }

      //6. FILTRAGE RIEN QUE PAR INCLUSION DU JOURNAL DE SITUATION
      if (empty($_GET['CompteFrom']) AND empty($_GET['CompteTo']) AND empty($_GET['JournalFrom']) AND empty($_GET['JournalTo']) AND !empty($_GET['Situation'])) {


        $Comptes = DB::table('compte_generals')
          ->join('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw('compte_generals.numero_compte,compte_generals.Intitule,compte_generals.id'))
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->groupBy('compte_generals.id')
          ->get();
          
        foreach ($Comptes as $Compte) {
          $EcritureD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MD');     

          $EcritureC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau', null)
            ->where('journals.Compte', $Compte->id)
            ->sum('journals.MC'); 

          $AnouveauD = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',1)
            ->where('journals.Compte',$Compte->id)
            ->sum('journals.MD');

          $AnouveauC = DB::table('journals')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->where('code_journauxes.ANouveau',1)
            ->where('journals.Compte',$Compte->id)
            ->sum('journals.MC');  
        
          $TAND+=$AnouveauD;
          $TANC+=$AnouveauC;
          $TD+=$EcritureD;
          $TC+=$EcritureC;

          $SDB = ($EcritureD-$EcritureC) + ($AnouveauD-$AnouveauC);
          
          if ($SDB < 0) {
            $SCD=$SDB*(-1);
            $SDB = 0;
          }else{
            $SCD=0;
          }
            
          $TSDB+=$SDB;
          $TSCD+=$SCD;

          $table.="
            <tbody>
              <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                <td colspan='1'>".$Compte->numero_compte."</td>
                <td colspan='1'>".$Compte->Intitule."</td>
                <td colspan='1'>".$AnouveauD."</td>
                <td colspan='1'>".$AnouveauC."</td>
                <td colspan='1'>".$EcritureD."</td>
                <td colspan='1'>".$EcritureC."</td>
                <td colspan='1'>".$SDB."</td>
                <td colspan='1'>".$SCD."</td>
              </tr>";  
        }
      }  
      $table.="
        <tr style='text-align:center;font-weight:bold;background-color:silver;'>
          <td colspan='2'>A reporter</td>
          <td colspan='1'>".$TAND."</td>
          <td colspan='1'>".$TANC."</td>
          <td colspan='1'>".$TD."</td>
          <td colspan='1'>".$TC."</td>
          <td colspan='1'>".$TSDB."</td>
          <td colspan='1'>".$TSCD."</td>
        </tr>";   
      return view('Comptabilite.Balance', compact('table','Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));         
    }

    public function Bilan_form(){
        $Comptes = CompteGeneral::all();
        $Codes = CodeJournaux::all();
        return view('Comptabilite/Etats.Bilan_form', compact('Comptes', 'Codes'));
    }

    public function edition_bilan(){

      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = "Journal de Situation exclus";

      if (!empty($_GET['Situation'])) {
         $IncludeSituation = "Journal de Situation inclus";
      }

      $TActifD = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Actif')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MD');

      $TActifC = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Actif')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MC');

      $TPassifD = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Passif')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MD');

      $TPassifC = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Passif')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MC');

        $TActif = $TActifD-$TActifC;
        $TPassif= $TPassifD-$TPassifC;

        if ($TActif<0) {
          $TActif*=-1;
        }
        if ($TPassif<0) {
          $TPassif*=-1;
        }
        
        $Resultat = $TActif-$TPassif;            
        $TPassif+=$Resultat;
        $RubriquesActif =DB::table('etat_financiers')
          ->select(DB::raw('Section'))
          ->whereTypeEtatAndPositionnement('Bilan', 'Actif')
          ->groupBy('Section')
          ->get();

        $RubriquesPassif =DB::table('etat_financiers')
          ->select(DB::raw('Section'))
          ->whereTypeEtatAndPositionnement('Bilan', 'Passif')
          ->groupBy('Section')
          ->get();                

        $table1="<tr style='background-color:silver;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>ACTIF</th></tr>";

        $table2="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>PASSIF</th></tr>";

        foreach ($RubriquesActif as $RubriqueActif) {
           $table1.="<tr>
              <th style='font-weight:bolder;font-size:15px' colspan='2'>".$RubriqueActif->Section."</th>
          </tr>";

          $Sous_rubriques =DB::table('etat_financiers')
            ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
            ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->select(DB::raw('etat_financiers.intitule,sum(journals.MD)-sum(journals.MC) as SNet'))
            ->where('Section', $RubriqueActif->Section)
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->groupBy('etat_financiers.id')
            ->get();

            foreach ($Sous_rubriques as $Sous_rubrique) {
              if ($Sous_rubrique->SNet<0) {
                  $SNet = $Sous_rubrique->SNet*(-1);
              }else{
                  $SNet = $Sous_rubrique->SNet;
              }
            $table1.="<tr>
              <th style='font-weight:bolder;text-align:justify'>".$Sous_rubrique->intitule."</th>
              <th style='font-weight:bolder;text-align:justify'>".$SNet."</th>
             </tr>";
           }            
        }
        
        $table1.="<tr style='background-color:silver;font-weight:bolder'><th style='font-weight:bolder;text-align:justify' colspan='1'>TOTAL GENERAL ACTIF</th><th style='text-align:justify'>".$TActif."</th></tr>";

        foreach ($RubriquesPassif as $RubriquePassif) {
           $table2.="<tr>
              <th style='font-weight:bolder;font-size:15px' colspan='2'>".$RubriquePassif->Section."</th>
          </tr>";

          $Sous_rubriques =DB::table('etat_financiers')
            ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
            ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
            ->select(DB::raw('etat_financiers.intitule,compte_generals.resultat_exercice,etat_financiers.id'))
            ->where('Section', $RubriquePassif->Section)
            ->groupBy('etat_financiers.id')
            ->get();
           
            foreach ($Sous_rubriques as $Sous_rubrique) {
            
          if ($Sous_rubrique->resultat_exercice==1) {
            $table2.="<tr style='color:red'>
              <th style='font-weight:bolder;text-align:justify'>".$Sous_rubrique->intitule."</th>
              <th style='font-weight:bolder;text-align:justify'>".$Resultat."</th>
             </tr>";
          }else{

            $JMD =DB::table('etat_financiers')
            ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
            ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->select(DB::raw(''))
            ->where('etat_financiers.id', $Sous_rubrique->id)
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->sum('journals.MD');

            $JMC =DB::table('etat_financiers')
            ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
            ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->select(DB::raw(''))
            ->where('etat_financiers.id', $Sous_rubrique->id)
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->sum('journals.MC');
            
            $SNet = $JMD-$JMC;

            if ($SNet<0) {
               $SNet *=(-1);
            }
             $table2.="<tr>
              <th style='font-weight:bolder;text-align:justify'>".$Sous_rubrique->intitule."</th>
              <th style='font-weight:bolder;text-align:justify'>".$SNet."</th>
             </tr>";
          } 
        }            
       }

        $table2.="<tr style='background-color:silver;font-weight:bolder'><th style='font-weight:bolder;text-align:justify' colspan='1'>TOTAL GENERAL PASSIF</th><th style='text-align:justify'>".$TPassif."</th></tr>";
      return view('Comptabilite.Bilan', compact('table1', 'table2','Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));
    }


    public function CompteResultat_form(){
        $Comptes = CompteGeneral::all();
        $Codes = CodeJournaux::all();
        return view('Comptabilite/Etats.CompteResultat_form', compact('Comptes', 'Codes'));
    }

    public function edition_compte_resultat(){

      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = '';

      $RubriquesProduit =DB::table('etat_financiers')
        ->select(DB::raw('Section'))
        ->whereTypeEtatAndPositionnement('Compte_resultat', 'Produit')
        ->groupBy('Section')
        ->get();

      $RubriquesCharge =DB::table('etat_financiers')
        ->select(DB::raw('Section'))
        ->whereTypeEtatAndPositionnement('Compte_resultat', 'Charge')
        ->groupBy('Section')
        ->get();

      $TotalProduitD = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Produit')
        ->where('etat_financiers.type_etat', 'Compte_resultat')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MD');

      $TotalProduitC = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Produit')
        ->where('etat_financiers.type_etat', 'Compte_resultat')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MC');  

      $TotalChargeD = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Charge')
        ->where('etat_financiers.type_etat', 'Compte_resultat')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MD');

      $TotalChargeC = DB::table('etat_financiers')
        ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id', '=', 'etat_financiers.id')
        ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
        ->wherePositionnement('Charge')
        ->where('etat_financiers.type_etat', 'Compte_resultat')
        ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
        ->sum('journals.MC');    

      $TotalProduit = $TotalProduitD - $TotalProduitC;
      $TotalCharge = $TotalChargeD - $TotalChargeC;

        if ($TotalProduit<0) {
          $TotalProduit*=-1;
        }      

        if ($TotalCharge<0) {
          $TotalCharge*=-1;
        }      

      $Resultat = $TotalProduit-$TotalCharge;

      $table1="<tr style='background-color:silver;font-weight:bolder'>
        <th style='font-weight:bolder' colspan='2'>PRODUITS</th>
        <th style='font-weight:bolder' colspan='1'>".$TotalProduit."</th>
        </tr>";

      $table2="<tr style='background-color:silver;font-weight:bolder'>
        <th style='font-weight:bolder' colspan='2'>CHARGES</th>
        <th style='font-weight:bolder' colspan='1'>".$TotalCharge."</th>
        </tr>";

      foreach ($RubriquesProduit as $key => $value) {
        $Sous_rubriques =DB::table('etat_financiers')
          ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
          ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
          ->leftJoin('journals', 'journals.Compte', '=', 'compte_generals.id')
          ->select(DB::raw('etat_financiers.intitule,sum(journals.MD)-sum(journals.MC) as SNet'))
          ->where('Section', $value->Section)
          ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
          ->groupBy('etat_financiers.id')
          ->get();

      foreach ($Sous_rubriques as $Sous_rubrique) {
        if ($Sous_rubrique->SNet<0) {
          $SNet = $Sous_rubrique->SNet*(-1);
        }else{
          $SNet = $Sous_rubrique->SNet;
        }
        $table1.="<tr>
          <th style='font-weight:bolder;text-align:justify' colspan='2'>".$Sous_rubrique->intitule."</th>
          <th style='font-weight:bolder;text-align:justify' colspan='1'>".$SNet."</th>
          </tr>";
      }

      $table1.="<tr style='background-color:rgb(135,206,235);'>
        <th style='font-weight:bolder;font-size:15px' colspan='2'>".$value->Section."</th>
        <th style='font-weight:bolder;font-size:15px' colspan='1'></th>
        </tr>";
    }

      foreach ($RubriquesCharge as $key => $value) {
          $Sous_rubriques =DB::table('etat_financiers')
            ->join('etat_financier_contents', 'etat_financier_contents.sous_rubrique_id','=', 'etat_financiers.id')
            ->join('compte_generals', 'compte_generals.id', '=', 'etat_financier_contents.compte_id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_generals.id')
            ->select(DB::raw('etat_financiers.intitule,sum(journals.MD)-sum(journals.MC) as SNet'))
            ->where('Section', $value->Section)
            ->whereBetween('journals.DateOperation', [$_GET['debut'],$_GET['fin']])
            ->groupBy('etat_financiers.id')
            ->get();

            foreach ($Sous_rubriques as $Sous_rubrique) {
              if ($Sous_rubrique->SNet<0) {
                  $SNet = $Sous_rubrique->SNet*(-1);
              }else{
                  $SNet = $Sous_rubrique->SNet;
              }
            $table2.="<tr>
              <th style='font-weight:bolder;text-align:justify' colspan='2'>".$Sous_rubrique->intitule."</th>
              <th style='font-weight:bolder;text-align:justify' colspan='1'>".$SNet."</th>
             </tr>";
        }

        $table2.="<tr style='background-color:rgb(135,206,235);'>
            <th style='font-weight:bolder;font-size:15px' colspan='2'>".$value->Section."</th>
            <th style='font-weight:bolder;font-size:15px' colspan='1'></th>
            </tr>";
        }
       
       $table2.="<tr>
            <th style='font-weight:bolder;font-size:15px' colspan='2'>Résultat de la Periode</th>
            <th style='font-weight:bolder;font-size:15px' colspan='1'>".$Resultat."</th>
            </tr>";    
        return view('Comptabilite.CompteResultat', compact('table1', 'table2','Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));
    }

    public function cash_flow_table_edition(){
      
      $Periode = $_GET['debut'].' à '.$_GET['fin'];
      $EchelonCompt = '';
      $EchelonJour = '';
      $IncludeSituation = "";

      $TotalReste = 0;
      $PreviewResultat = 0;
      $VariationTP = 0;
      $table1='';
      $table2='';
      $table3='';


      $Contents1 =DB::table('etat_financiers')
          ->select(DB::raw('intitule,id'))
          ->where('Section', "FLUX DE TRéSORERIE PROVENANT DES ACTIVITéS OPERATIONNELLES")->get();

        foreach ($Contents1 as $Content1) {
          $montantD = DB::table('etat_financier_contents')
            ->join('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->leftJoin('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content1->id)
            ->sum('journals.MD');
          
          $montantC = DB::table('etat_financier_contents')
            ->leftJoin('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content1->id)
            ->sum('journals.MC');
            
            $Reste = $montantD-$montantC;
            $table1.="<tr><td>".$Content1->intitule."</td><td>".$Reste."</td><td></td></tr>";

            $TotalReste+= $Reste;
        } 
        
        $VariationTP+=$TotalReste;

        $table1.="<tr style='background-color:silver;'><td>FLUX DE TRéSORERIE PROVENANT DES ACTIVITES OPERATIONNELLES (A)</td><td>".$TotalReste."</td><td></td></tr>";
      
      $TotalReste = 0;
        $Contents2 =DB::table('etat_financiers')
          ->select(DB::raw('intitule,id'))
          ->where('Section', "FLUX DE TRéSORERIE PROVENANT DES ACTIVITéS D'INVESTISSEMENT")->get();

        foreach ($Contents2 as $Content2) {
          $montantD = DB::table('etat_financier_contents')
            ->leftJoin('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content2->id)
            ->sum('journals.MD');
          
          $montantC = DB::table('etat_financier_contents')
            ->leftJoin('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content2->id)
            ->sum('journals.MC');
            
            $Reste = $montantD-$montantC;

            $table2.="<tr><td>".$Content2->intitule."</td><td>".$Reste."</td><td></td></tr>";

            $TotalReste+= $Reste;
        } 
        
        $VariationTP+=$TotalReste;

        $table2.="<tr style='background-color:silver;'><td>FLUX DE TRESORERIE PROVENANT DES ACTIVITES D'INVESTISSEMENT (B)</td><td>".$TotalReste."</td><td></td></tr>";

      $TotalReste = 0;

        $Contents3 =DB::table('etat_financiers')
          ->select(DB::raw('intitule,id'))
          ->where('Section', "FLUX DE TRéSORERIE PROVENANT DES ACTIVITéS DE FINANCEMENT")->get();

        foreach ($Contents3 as $Content3) {

          $montantD = DB::table('etat_financier_contents')
            ->leftJoin('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content3->id)
            ->sum('journals.MD');
          
          $montantC = DB::table('etat_financier_contents')
            ->leftJoin('journals', 'journals.Compte', '=', 'etat_financier_contents.compte_id')
            ->join('journal_mensuelles', 'journal_mensuelles.id', '=', 'journals.journal_id')
            ->join('code_journauxes', 'code_journauxes.id', '=', 'journal_mensuelles.journal_id')
            ->select(DB::raw(''))
            ->where('code_journauxes.ANouveau', NULL)
            ->where('etat_financier_contents.sous_rubrique_id', $Content3->id)
            ->sum('journals.MC');
            
            $Reste = $montantD-$montantC;
            $table3.="<tr><td>".$Content3->intitule."</td><td>".$Reste."</td><td></td></tr>";

            $TotalReste+= $Reste;
        } 
        
        $VariationTP+=$TotalReste;

        $table3.="<tr style='background-color:silver;'><td>FLUX DE TRESORERIE PROVENANT DES ACTIVITES DE FINANCEMENT (C)</td><td>".$TotalReste."</td><td></td></tr>";
        
        $CurentR = $VariationTP +$PreviewResultat;
        $table3.="

         <tr style='font-weight:bolder;'><td>Variation de Trésorerie de la Période (A+B+C)</td><td>".$VariationTP."</td><td></td></tr>

        <tr><td>Trésorerie et équivalents de trésorerie à l'ouverture de l'exercice (D)</td><td>".$PreviewResultat."</td><td></td></tr>
        

        <tr><td>Trésorerie et équivalents de trésorerie à la cloture de l'exercice (A+B+C+D) </td><td>".$CurentR."</td><td></td></tr>";

        return view('Comptabilite/Cash_flow_table', compact('table1', 'table2', 'table3','Periode', 'EchelonCompt', 'EchelonJour', 'IncludeSituation'));
    }
}
