<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\sectionAnalytique;
use App\Models\Journal;
use App\Models\Ventillation;
use DB;
class ControllerVentillation extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $montants = $request['montant'];
        $sections = $request['section'];
        $i=0;

        if ($request['montant']!=0) {
            for ($i=0; $i <count($request['montant']) ; $i++) { 
                $montant = (int)$montants[$i];
                if ($montant>0) {
                    $section = (int)$sections[$i];
                    $Nbre = Ventillation::whereEcritureIdAndSectionAnalytiqueId($request->ecriture_id,$section)->count('id');

                    if ($Nbre==0) {
                        Ventillation::create([
                            'ecriture_id'=>$request->ecriture_id,
                            'section_analytique_id'=>$section,
                            'montant'=>$montant
                        ]);
                    }elseif ($Nbre!=0 AND !empty($montant)) {
                        $Ventil = Ventillation::whereEcritureIdAndSectionAnalytiqueId($request->ecriture_id,$section)->first();

                        $Ventil->update([
                            'ecriture_id'=>$request->ecriture_id,
                            'section_analytique_id'=>$section,
                            'montant'=>$montant
                        ]);

                    }elseif ($Nbre!=0 AND empty($montant)) {
                        $Ventil = Ventillation::whereEcritureIdAndSectionAnalytiqueId($request->ecriture_id,$section)->first();

                        $Ventil->destroy($Ventil->id);
                    }
                }
            }
        } 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        $table = "";
        $Nbre = Ventillation::whereEcritureId($id)->count('id');
        $ventillations = Ventillation::whereEcritureId($id)->get();

        $Sections = sectionAnalytique::all(); 

       foreach ($Sections as $key => $value) {
        $ventillation = Ventillation::whereEcritureIdAndSectionAnalytiqueId($id,$value->id)->first();
        if (!is_null($ventillation)) {

                $table.="<tr>
                <td style='display: none;'><input type='text' name='section[]' value=".$value->id."></td>
                <td>".$value->numero_compte."</td>
                <td>".$value->section."</td><td colspan='2'><input type='number' onkeyup='checkamount_equal_to_zero();' name='montant[]' value=".$ventillation->montant." class='input_amont'></td>
                    </tr>";
            }else{
                $table.="<tr>
                <td style='display: none;'><input type='text' name='section[]' value=".$value->id."></td>
                <td>".$value->numero_compte."</td>
                <td>".$value->section."</td><td colspan='2'><input type='number' onkeyup='checkamount_equal_to_zero();' name='montant[]' value='' class='input_amont'></td>
                    </tr>";
            }
         }
        $ecriture = Journal::findOrFail($id);
        return view('Comptabilite/Analytique/Section.ventillation', compact('table', 'ecriture', 'id'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
