<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use App\Models\Module;
use Illuminate\Support\Facades\DB;
use Form;
class RoleController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:role-list|role-create|role-edit|role-delete', ['only' => ['index','store']]);
        $this->middleware('permission:role-create', ['only' => ['create','store']]);
        $this->middleware('permission:role-edit', ['only' => ['edit','update']]);
        $this->middleware('permission:role-delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $roles = Role::all();
        return view('roles.index', compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $permission = Permission::get();
         $Modules = Module::all();
        
        $form = "";
        
            foreach ($Modules as $key => $value){
                $form.="<div class='row' id=".'parents'.$value->id." style='background-color:black;color:white;padding:10px'>".$value->module."<input class='form-check-input' value=".'parents'.$value->id." onclick='getChildren(this)' type='checkbox'></div>";

               $permissions =DB::table('permissions')
                    ->select(DB::raw('permissions.id, permissions.name'))
                    ->where('module_id', $value->id)
                    ->get();

                foreach ($permissions as $key => $val) {
                     $form.="<div class='col-md-12'>
                        <input class='form-check-input' name='permission[]' type='checkbox' value=".$val->id.">".$val->name."</div>";
                }
            }
                          
        return view('roles.create', compact('form'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:roles,name',
            'permission' => 'required',
        ]);
    
        $role = Role::create(['name' => $request->input('name')]);
        $role->syncPermissions($request->input('permission'));
    
        return redirect()->route('roles.index')
            ->with('success', 'Role created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $role = Role::find($id);
        $rolePermissions = Permission::join('role_has_permissions', 'role_has_permissions.permission_id', 'permissions.id')
            ->where('role_has_permissions.role_id',$id)
            ->get();
    
        return view('roles.show', compact('role', 'rolePermissions'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   $Modules = Module::all();
        $form = "";
        $role = Role::find($id);

        foreach ($Modules as $key => $value){
            $form.="<div class='row' id=".'parents'.$value->id." style='background-color:black;color:white;padding:10px'>".$value->module."<input class='form-check-input' value=".'parents'.$value->id." onclick='getChildren(this)' type='checkbox'></div>";

            $permissions =DB::table('permissions')
                ->select(DB::raw('permissions.id, permissions.name'))
                ->where('module_id', $value->id)
                ->get();
                
            $rolePermissions = DB::table('role_has_permissions')
                ->join('permissions', 'permissions.id', '=', 'role_has_permissions.permission_id')
                ->join('modules', 'modules.id', '=', 'permissions.module_id')
                ->where('role_has_permissions.role_id', $id)
                ->where('permissions.module_id', $value->id)
                ->pluck('role_has_permissions.permission_id', 'role_has_permissions.permission_id')
                ->all();

                foreach ($permissions as $key => $val) {
                     $form.="<div class='col-md-12'>
                                ".Form::checkbox('permission[]', $val->id, in_array($val->id, $rolePermissions) ? true : false, array('class' => 'form-check-input'))."".$val->name."
                            </div>";
                }
            }
        return view('roles.edit', compact('role', 'form', 'rolePermissions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'permission' => 'required',
        ]);
    
        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->save();
    
        $role->syncPermissions($request->input('permission'));
    
        return redirect()->route('roles.index')
            ->with('success', 'Role updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Role::find($id)->delete();
        
        return redirect()->route('roles.index')
            ->with('success', 'Role deleted successfully');
    }
}
